/*
 * written by Steven Chaitoff
 */


/*
* LOADING PREVIEW IMAGE/MAGNIFYING EFFECT
*/


// functions for loading the preview image and the magnifying glass effect
Context = {

magnifiable : false,	// indicates if capture is large enough such that the user is able to magnify it
dragging : false,	// indicates whether user is just moving the mouse or dragging it (holding the button down)

canvas : null, capture : null, loupe : null, reflection : null, ctx : null, img : null,

rate : .08,		aspect : 0,		// rate is mouse strength necessary to zoom in/out.  aspect is aspect ratio of sizeY/sizeX
sizeX : 0,		sizeY : 0,		// sizeX, sizeY are ACTUAL DIMENSIONS of captured image in pixels
absX : 291,		absY : 150,		// these values are the dimensions in pixels of the previewable area.  They shouldn't be changed.  See style-sheet #imgdiv1
posX : 0,		posY : 0,		// distance btwn img left & top edges and preview areas left & top edges, respectively.
ofstX : 10,		ofstY : 43,		// distance canvas is from left/top edges of widget, necessary since mouse coordinates are captured absolutely
smallX : 0,		smallY : 0,		// these values are the dimensions of the capture once they are fitted within the constraints of absX, absY
zoomX : 1,		zoomY : 1,		// these range from 0-1 = 0% to 100% of sizeX, sizeY
lastX : 0,		lastY : 0,		// mouse coords when mouse is moved
freezeX : 0,	freezeY : 0,	// mouse coords when mouse is clicked


// methods
display :
function(capture_file) {
	this.zoomX = this.zoomY = 1;
	this.lastX = this.lastY = this.freezeX = this.freezeY = 0;

	this.img.visibility = 'hidden';
	this.capture.src = capture_file + '?' + Math.random(); // add random query string to avoid loading browser-cached file
	this.img.width = this.img.height = null;

	this.capture.onload = function() {
		Context.measure();
		Context.scale();
		Context.mgcheck();
		Context.img.visibility = 'visible';
		if (!expanded) Stretcher.stretch();
	};
},



measure : // get actual dimensions of screen capture via getComputedStyle
function() {
	this.sizeY = parseInt(document.defaultView.getComputedStyle(this.capture, '').getPropertyValue("height"));
	this.sizeX = parseInt(document.defaultView.getComputedStyle(this.capture, '').getPropertyValue("width"));
	this.aspect = this.sizeY / this.sizeX;
},



mgcheck : 
function() {
	this.magnifiable = !((this.sizeX < this.absX + 50) && (this.sizeY < this.absY + this.aspect * 50));
	this.showing(this.magnifiable);
},



scale :
function() {
	if (this.aspect >= this.absY / this.absX && this.sizeY > this.absY) {
		this.img.height = this.absY;
		this.img.width = this.absY / this.aspect;
	}
	else if (this.aspect < this.absY / this.absX && this.sizeX > this.absX) {
		this.img.width = this.absX;
		this.img.height = this.aspect * this.absX;
	}
	else {
		this.img.width = this.sizeX;
		this.img.height = this.sizeY;
	}
	
	this.smallX = parseInt(this.img.width);
	this.smallY = parseInt(this.img.height);
	this.posX = (this.absX - this.smallX) / 2;
	this.posY = (this.absY - this.smallY) / 2;
},



set_state : // canvas mouseup/mousedown handler
function(b) {
	if (this.dragging = b) {
		this.freezeX = this.lastX = event.x;
		this.freezeY = this.lastY = event.y;
	}
},



move_state : // canvas mousemove handler
function() {
	if (!this.magnifiable || Stretcher.stretching) return 0;
	if (this.dragging) {
		if (event.y > this.lastY && this.sizeY * (this.zoomY - this.rate) >= this.smallY) {
			this.zoomX -= this.rate;
			this.zoomY -= this.rate;
		}
		else if (event.y < this.lastY && this.sizeY * (this.zoomY + this.rate) <= this.sizeY*2) {
			this.zoomX += this.rate;
			this.zoomY += this.rate;
		}
		this.lastX = event.x;
		this.lastY = event.y;
		this.draw(this.freezeX, this.freezeY);
	}
	else this.draw(event.x, event.y);
},



clear_state :
function() { // canvas mousemove handler clears the loupe image (so it goes away when mouse leaves the canvas)
	this.ctx.restore();
	this.ctx.clearRect(0, 0, this.absX, this.absY)
	this.ctx.save();
},



draw : // mx, my are cursor coords
function(mx, my, mouse_out) {
	this.ctx.restore();
	this.ctx.clearRect(0, 0, this.absX, this.absY)
	this.ctx.save();

	this.ctx.drawImage(this.loupe,mx-this.ofstX-46,my-this.ofstY-46,100,95);
	this.ctx.beginPath();
	// draws a circle that is the inside of the loupe
	// arc is 43 in radius = half of pixel width of the reflection image (inside of the loupe)
	this.ctx.arc(mx-this.ofstX,my-this.ofstY,43,0,Math.PI*2,true);
	this.ctx.clip();	// masks the image outside of the magnifying glass

	// dx, dy coords below are the relative coords of the capture that are to be magnified
	var dx = ((mx-this.posX-this.ofstX) / this.smallX) * (this.smallX - this.sizeX * this.zoomX);
	var dy = ((my-this.posY-this.ofstY) / this.smallY) * (this.smallY - this.sizeY * this.zoomY);

	this.ctx.drawImage(this.capture, dx+this.posX, dy+this.posY, this.sizeX*this.zoomX, this.sizeY*this.zoomY);	// draw the capture
	this.ctx.drawImage(this.reflection,mx-this.ofstX-43,my-this.ofstY-43,86,86);	// put "reflection" over glass

},



showing :
function(v) {
	this.canvas.style.display = v ? 'block' : 'none';
}

};

